<?php
session_start();

if(!$_SESSION['isadmin'])
{
	header("Location: login.php?ref=edit.php?pageid=1");
	exit;
}

if($_SESSION['country_login'] == 1 || $_SESSION['country_login'] == 2) {
	header("Location: index.php");
	exit;
}

include_once("../functions.php");
$conn = dbconnect();

if($_POST['select_random_winners']) {
	$win_array = unserialize($_POST['winners_array']);
	$club_id=mysqli_real_escape_string($conn,$_POST['golfclub']);
	$pack_name = base64_decode($_POST['packs']);
	$query =  "UPDATE stickers_tt SET winner=1 WHERE clubid=".$club_id." AND packname='".$pack_name."' AND barcode IN ('".implode("','",$win_array)."')";
	mysqli_query($conn,$query);
}

//Check if club country login and has access to this club
if($_SESSION['country_login'] == 1 && $_GET['cid']) {
	$has_access = mysqli_num_rows(mysqli_query($conn,"SELECT country FROM club_registrations WHERE id=".mysqli_real_escape_string($conn,$_GET['cid'])." AND country IN (".$_SESSION['country_access_array'].")"));
	
	if($has_access!==1) {
		header("Location: index.php");
		exit;
	}
}
include "headers/common_header.php";

if($_SESSION['country_login'] == 1) {
	$get_all_clubs = mysqli_query($conn,"SELECT * FROM club_registrations WHERE country IN (".$_SESSION['country_access_array'].") AND hideit=0 ORDER BY golfclub ASC");
} else {
	$get_all_clubs = mysqli_query($conn,"SELECT * FROM club_registrations WHERE hideit=0 ORDER BY golfclub ASC");
}

if($_GET['cid']){

    $currency_symbol = get_currency($_GET['cid'],$conn);
        
}
?>

<!--BEGIN PAGE WRAPPER-->

        <div id="page-wrapper"><!--BEGIN TITLE & BREADCRUMB PAGE-->

            <div id="title-breadcrumb-option-demo" class="page-title-breadcrumb">

                <div class="page-header pull-left">

                    <div class="page-title">Define Winning Tickets</div>

                </div>

                <ol class="breadcrumb page-breadcrumb pull-right">

                    <li><i class="fa fa-home"></i>&nbsp;<a href="index.php">Home</a>&nbsp;&nbsp;<i class="fa fa-angle-right"></i>&nbsp;&nbsp;</li>

                    <li class="active">Define wins</li>

                </ol>

                <div class="clearfix"></div>

            </div>

            <!--END TITLE & BREADCRUMB PAGE-->

			<!--BEGIN CONTENT-->

            <div class="page-content">

                <div id="form-layouts" class="row">

                                    <div class="col-lg-12">

                                        <div class="panel panel-green">

                                            <div class="panel-heading">Please select club and pack to see scratchies in that pack:</div>

                                            <div class="panel-body pan">

                                                <form action="#" method="post" id="assign_stickers" class="form-horizontal" enctype="multipart/form-data">

                                                    <div class="form-body pal">

														<div class="form-group"><label for="country" class="col-md-3 control-label">Select Golf Club </label>

                                                            <div class="col-md-9">

                                                                <div class="input-icon">
																<select name="golfclub" class="form-control" onchange="window.location='define_winning_stickers_tt.php?cid='+this.value">
																<option value="0">-Select-</option>
																<?php while($golf_club = mysqli_fetch_array($get_all_clubs)) {?>
                                                                <option <?php if($_GET['cid']==$golf_club['id']) {?> selected="selected" <?php }?> value="<?php echo $golf_club['id']?>"><?php echo $golf_club['golfclub']." ".$golf_club['businessname']?></option>
                                                                <?php }?>
                                                                </select>
                                                            </div>
                                                        </div>
                                                       </div>
													   
														<div class="form-group"><label for="contactname" class="col-md-3 control-label">Select Pack</label>
														<?php
														$club_packs = mysqli_query($conn,"SELECT distinct packname FROM stickers_tt WHERE clubid=".mysqli_real_escape_string($conn,$_GET['cid']));
														?>

                                                            <div class="col-md-9">

                                                                <div class="input-icon">
																<select name="packs" class="form-control">
																<?php while($packs = mysqli_fetch_array($club_packs)) {?>
																<option value="<?php echo base64_encode($packs['packname'])?>" <?php if($_REQUEST['packs']==base64_encode($packs['packname'])) {?> selected="selected" <?php }?>><?php echo $packs['packname']?></option>							
																<?php }?>									
																</select>
																</div>

                                                            </div>

                                                        </div>

                                                        <div class="form-actions none-bg">

                                                        <div class="col-md-offset-3 col-md-9">
															Win Amount: <input type="text" name="winamount">
                                                           <input type="submit" name="assign" value="Spread" class="btn btn-primary">

                                                        </div>

                                                    </div>

                                                </form>

                                            </div>

                                        </div>

                                    </div>

                                </div>
								
								
								<div class="col-lg-12">

                                        <div class="panel panel-green">
										<?php 
										if($_POST['packs'] && $_POST['golfclub']) {?>
                                            <div class="panel-heading">Generate winners for this pack</div>
											
											<div id="mydiv">
											
                                            <div class="panel-body pan">
												
												 <div id="no-more-tables">

                                    <table class="table table-bordered table-striped table-condensed cf" style="width:100%">

                                        <thead class="cf">

                                        <tr>

											<th class="numeric" style="text-align:center">Sr.</th>
											
                                            <th class="numeric" style="text-align:center">Barcode</th>

                                            <th class="numeric" style="text-align:center">Chances</th>
											
											<th class="numeric" style="text-align:center">Score</th>

                                            <th class="numeric" style="text-align:center">Amount</th>

                                            <th class="numeric" style="text-align:center">Booked</th>

                                            <th class="numeric" style="text-align:center">Winner</th>
											
											<th class="numeric" style="text-align:center">Method</th>
											
                                        </tr>

                                        </thead>

                                        <tbody>
																			
										<?php 
										$tots = $has_winner = mysqli_num_rows(mysqli_query($conn,"SELECT id FROM stickers_tt WHERE clubid=".mysqli_real_escape_string($conn,$_GET['cid'])." AND packname='".base64_decode($_POST['packs'])."'"));
										$has_winner = mysqli_num_rows(mysqli_query($conn,"SELECT winner FROM stickers_tt WHERE winner=1 AND clubid=".mysqli_real_escape_string($conn,$_GET['cid'])." AND packname='".base64_decode($_POST['packs'])."'"));
											if($has_winner==0) {
											
											$myids1 = mysqli_query($conn,"SELECT * FROM stickers_tt WHERE clubid=".mysqli_real_escape_string($conn,$_POST['golfclub'])." AND packname='".base64_decode($_POST['packs'])."' ORDER BY RAND()");
											$total_win_amt = $_POST['winamount'];
											$summ = 0;
											
											$myids = array();
											while($mi = mysqli_fetch_array($myids1)) {
												if($summ<$total_win_amt) {
													$myids[] = $mi['id'];
													$summ = $summ+$mi['amount'];
												}
											}
											
											$arrayids = implode("','",$myids);
											
											$get_scratchies = mysqli_query($conn,"SELECT * FROM stickers_tt WHERE clubid=".mysqli_real_escape_string($conn,$_POST['golfclub'])." AND packname='".base64_decode($_POST['packs'])."' AND id IN('".$arrayids."')");
											
											}
											else {
											$get_scratchies = mysqli_query($conn,"SELECT * FROM stickers_tt WHERE clubid=".mysqli_real_escape_string($conn,$_POST['golfclub'])." AND packname='".base64_decode($_POST['packs'])."' ORDER BY winner DESC, id");
											$get_scratchies_r = mysqli_query($conn,"SELECT * FROM stickers_tt WHERE clubid=".mysqli_real_escape_string($conn,$_POST['golfclub'])." AND packname='".base64_decode($_POST['packs'])."' AND winner=1 ORDER BY winner DESC, id");
											
											while($r=mysqli_fetch_array($get_scratchies_r)){
											    $br_no = explode('_',$r['barcode']);
												$barcode_array_num_w[]=$br_no[sizeof($br_no)-1];
											}
											
											}
											
											$sr = 1;
											$sumA=0;
											$sumB=0;
											$Awin=0;
											$Bwin=0;
											
											$barcode_array=array();
											while($scratchie = mysqli_fetch_array($get_scratchies)) {
											    
											$br_no1 = explode('_',$scratchie['barcode']);
											    
											$barcode_array[]=$scratchie['barcode'];
											$barcode_array_num[]=$br_no1[sizeof($br_no1)-1];
										?>

										<tr>
											<td style="text-align:center"><?php echo $sr; ?></td>
											<td style="text-align:center"><?php echo $scratchie['barcode'];?></td>
											<td style="text-align:center"><?php echo $scratchie['chances']?></td>
											<td style="text-align:center"><?php echo $scratchie['score']?></td>
											<td style="text-align:center"><?php echo $currency_symbol.$scratchie['amount'];?></td>
											<td style="text-align:center">
												<?php echo $scratchie['booked']?"Yes":"-";?>
												<span><?php if($scratchie['booked']) echo "<br /> ".date('jS M Y',strtotime($scratchie['bookedon'])); ?></span>
											</td>
											<td style="text-align:center">
												
												<select name="win_sticker" onchange="update_winner_sticker('<?php echo $scratchie['barcode'];?>', <?php echo $_POST['golfclub']?>,$(this).val(),<?php echo $scratchie['id']?>)">
												<option value="1" <?php if($scratchie['winner']==1) {?> selected="selected" <?php }?>>Yes</option>
												<option value="0" <?php if($scratchie['winner']==0) {?> selected="selected" <?php }?>>No</option>
												</select>
												<div id="win_<?php echo $scratchie['barcode'];?>"></div>
											</td>
											
											<td style="text-align:center">
												<?php if($has_winner==0) {?>
												<?php echo $scratchie['method']; ?>
												<?php } else {?>
												<select name="win_method" onchange="update_method('<?php echo $scratchie['barcode'];?>', <?php echo $_POST['golfclub']?>,$(this).val(),<?php echo $scratchie['id']?>)">
												<option value="A" <?php if($scratchie['method']=="A") {?> selected="selected" <?php }?>>A</option>
												<option value="B" <?php if($scratchie['method']=="B") {?> selected="selected" <?php }?>>B</option>
												</select>
												<?php }?>
												<div id="<?php echo $scratchie['barcode'];?>"></div>
											</td>
											
										</tr>
										
										<?php $sr++; 
										
										if($scratchie['winner']==1) {
											if($scratchie['method']=='A') {
												$sumA+=$scratchie['amount'];
												$Awin++;
											}
											
											if($scratchie['method']=='B') {
												$sumB+=$scratchie['amount']; 
												$Bwin++;
											}
											
											$win_cnt++;
											$tot_winner+=$scratchie['amount'];
										}
										
										if($has_winner==0) {
											$tot_winner+=$scratchie['amount'];
										}
										
										
										}?>
										
										</tbody>
										<tr><td></td><td></td><td></td><td></td><td style="text-align:center">Win amount:<?php if($tot_winner) { echo $currency_symbol.($tot_winner); } else { echo "$0"; }?></td><td></td><td></td><td></td></tr>
										</table>
										
										<table style="width:100%">
										<tr>
										<?php 
										//$get_scratchies = mysqli_query($conn,"SELECT * FROM stickers_tt WHERE clubid=".$_POST['golfclub']." AND packname='".base64_decode($_POST['packs'])."' ORDER BY winner DESC, method ASC");
										if($has_winner==0) {
											$barcode_array_num = $barcode_array_num;
										} else {
											$barcode_array_num = $barcode_array_num_w;
										}
										
										$starts_with = mysqli_fetch_array(mysqli_query($conn,"SELECT id FROM stickers_tt WHERE clubid=".mysqli_real_escape_string($conn,$_GET['cid'])." AND packname='".base64_decode($_POST['packs'])."' ORDER BY id ASC limit 0,1"));
										
										$starts_with_id = $starts_with['id'];
										$ends_with_id = $starts_with['id']+$tots;
                                        
										for($s=$starts_with_id; $s<=$ends_with_id; $s++) {?>
										
										<td <?php if(in_array(intval($s), $barcode_array_num)) {?> style="background-color:#00FF00; width=1px;; border:1px solid #FFFFFF" <?php } else {?> style="background-color:#000000; width:1px; border:1px solid #FFFFFF" <?php }?>>&nbsp;</td>
										
										<?php }?>
										</tr>
										</table>
										
										</div>
										<?php 
										$array_data = serialize($barcode_array);
										}?>
										
										<div class="panel-heading" style="font-size:18px"><?php echo $win_cnt; ?> Stickers are winning in this pack<br /> <br />Method A:<br /><?php echo $currency_symbol.($sumA); ?> (<?php echo $Awin?> stickers) <br /><br />Method B: <br /><?php echo $currency_symbol.($sumB);?> (<?php echo $Bwin?> stickers) <br /><br />
			
<form action="#" method="POST">
<input type="hidden" name="packs" value="<?php echo $_POST['packs']?>">
<input type="hidden" name="golfclub" value="<?php echo $_GET['cid']?>">
<input type="hidden" name="winners_array" value='<?php echo $array_data?>'>
<?php
if($has_winner==0) {
?>
<input type="submit" name="select_random_winners" value="Looks good, go ahead">
<?php } ?>
</form>
											</div>
										
                                            </div>
											</div>

                                        </div>

                                    </div>

                                </div>

                            </div>

            <!--END CONTENT-->
<script>
function update_method(barcode, clubid, method, id) {
            $.ajax({
                type: "GET",
                url: 'update_win_method_sticker_tt_ajax.php',
                data: { club_id:clubid, barcode_num:barcode, win_method:method, barid:id},
				beforeSend: function(){
          		 	$('#'+barcode).html("Saving");
        		},
                success: function(data) {
                    $('#'+barcode).html(data);
                },
                 error: function() {
                    $('#'+barcode).html('Something went wrong');
                },
                complete: function() {
                    //$('#'+barcode).html(data);
                }
            });
      };

function update_winner_sticker(barcode, clubid, winner, id) {
            $.ajax({
                type: "GET",
                url: 'update_win_sticker_tt_ajax.php',
                data: { club_id:clubid, barcode_num:barcode, winner_sticker:winner, barid:id},
				beforeSend: function(){
          		 	$('#win_'+barcode).html("Saving");
        		},
                success: function(data) {
                    $('#win_'+barcode).html(data);
                },
                 error: function() {
                    $('#win_'+barcode).html('Something went wrong');
                },
                complete: function() {
                    //$('#'+barcode).html(data);
                }
            });
      };
</script>
<?php include "footer.php";?>