$(function () {



    /* Basic area */

    $('#basic-area').highcharts({

        chart: {

            type: 'area'

        },

        title: {

            text: 'US and USSR nuclear stockpiles'

        },

        subtitle: {

            text: 'Source: <a href="http://thebulletin.metapress.com/content/c4120650912x74k7/fulltext.pdf">'+

                'thebulletin.metapress.com</a>'

        },

        xAxis: {

            labels: {

                formatter: function() {

                    return this.value; // clean, unformatted number for year

                }

            }

        },

        yAxis: {

            title: {

                text: 'Nuclear weapon states'

            },

            labels: {

                formatter: function() {

                    return this.value / 1000 +'k';

                }

            }

        },

        tooltip: {

            pointFormat: '{series.name} produced <b>{point.y:,.0f}</b><br/>warheads in {point.x}'

        },

        plotOptions: {

            area: {

                pointStart: 1940,

                marker: {

                    enabled: false,

                    symbol: 'circle',

                    radius: 2,

                    states: {

                        hover: {

                            enabled: true

                        }

                    }

                }

            }

        },

        series: [{

            name: 'USA',

            data: [null, null, null, null, null, 6 , 11, 32, 110, 235, 369, 640,

                1005, 1436, 2063, 3057, 4618, 6444, 9822, 15468, 20434, 24126,

                27387, 29459, 31056, 31982, 32040, 31233, 29224, 27342, 26662,

                26956, 27912, 28999, 28965, 27826, 25579, 25722, 24826, 24605,

                24304, 23464, 23708, 24099, 24357, 24237, 24401, 24344, 23586,

                22380, 21004, 17287, 14747, 13076, 12555, 12144, 11009, 10950,

                10871, 10824, 10577, 10527, 10475, 10421, 10358, 10295, 10104 ]

        }, {

            name: 'USSR/Russia',

            data: [null, null, null, null, null, null, null , null , null ,null,

                5, 25, 50, 120, 150, 200, 426, 660, 869, 1060, 1605, 2471, 3322,

                4238, 5221, 6129, 7089, 8339, 9399, 10538, 11643, 13092, 14478,

                15915, 17385, 19055, 21205, 23044, 25393, 27935, 30062, 32049,

                33952, 35804, 37431, 39197, 45000, 43000, 41000, 39000, 37000,

                35000, 33000, 31000, 29000, 27000, 25000, 24000, 23000, 22000,

                21000, 20000, 19000, 18000, 18000, 17000, 16000]

        }]

    });



    /* Area with negative values */

    $('#area-with-negative-values').highcharts({

        chart: {

            type: 'area'

        },

        title: {

            text: 'Area chart with negative values'

        },

        xAxis: {

            categories: ['Apples', 'Oranges', 'Pears', 'Grapes', 'Bananas']

        },

        credits: {

            enabled: false

        },

        series: [{

            name: 'John',

            data: [5, 3, 4, 7, 2]

        }, {

            name: 'Jane',

            data: [2, -2, -3, 2, 1]

        }, {

            name: 'Joe',

            data: [3, 4, 4, -2, 5]

        }]

    });



    /* Stacked area */

    $('#stacked-area').highcharts({

        chart: {

            type: 'area'

        },

        title: {

            text: 'Historic and Estimated Worldwide Population Growth by Region'

        },

        subtitle: {

            text: 'Source: Wikipedia.org'

        },

        xAxis: {

            categories: ['1750', '1800', '1850', '1900', '1950', '1999', '2050'],

            tickmarkPlacement: 'on',

            title: {

                enabled: false

            }

        },

        yAxis: {

            title: {

                text: 'Billions'

            },

            labels: {

                formatter: function() {

                    return this.value / 1000;

                }

            }

        },

        tooltip: {

            shared: true,

            valueSuffix: ' millions'

        },

        plotOptions: {

            area: {

                stacking: 'normal',

                lineColor: '#666666',

                lineWidth: 1,

                marker: {

                    lineWidth: 1,

                    lineColor: '#666666'

                }

            }

        },

        series: [{

            name: 'Asia',

            data: [502, 635, 809, 947, 1402, 3634, 5268]

        }, {

            name: 'Africa',

            data: [106, 107, 111, 133, 221, 767, 1766]

        }, {

            name: 'Europe',

            data: [163, 203, 276, 408, 547, 729, 628]

        }, {

            name: 'America',

            data: [18, 31, 54, 156, 339, 818, 1201]

        }, {

            name: 'Oceania',

            data: [2, 2, 2, 6, 13, 30, 46]

        }]

    });



    /* Percentage area */

    $('#percentage-area').highcharts({

        chart: {

            type: 'area'

        },

        title: {

            text: 'Historic and Estimated Worldwide Population Distribution by Region'

        },

        subtitle: {

            text: 'Source: Wikipedia.org'

        },

        xAxis: {

            categories: ['1750', '1800', '1850', '1900', '1950', '1999', '2050'],

            tickmarkPlacement: 'on',

            title: {

                enabled: false

            }

        },

        yAxis: {

            title: {

                text: 'Percent'

            }

        },

        tooltip: {

            pointFormat: '<span style="color:{series.color}">{series.name}</span>: <b>{point.percentage:.1f}%</b> ({point.y:,.0f} millions)<br/>',

            shared: true

        },

        plotOptions: {

            area: {

                stacking: 'percent',

                lineColor: '#ffffff',

                lineWidth: 1,

                marker: {

                    lineWidth: 1,

                    lineColor: '#ffffff'

                }

            }

        },

        series: [{

            name: 'Asia',

            data: [502, 635, 809, 947, 1402, 3634, 5268]

        }, {

            name: 'Africa',

            data: [106, 107, 111, 133, 221, 767, 1766]

        }, {

            name: 'Europe',

            data: [163, 203, 276, 408, 547, 729, 628]

        }, {

            name: 'America',

            data: [18, 31, 54, 156, 339, 818, 1201]

        }, {

            name: 'Oceania',

            data: [2, 2, 2, 6, 13, 30, 46]

        }]

    });



    /* Area with missing points */

    $('#area-with-missing-points').highcharts({

        chart: {

            type: 'area',

            spacingBottom: 30

        },

        title: {

            text: 'Fruit consumption *'

        },

        subtitle: {

            text: '* Jane\'s banana consumption is unknown',

            floating: true,

            align: 'right',

            verticalAlign: 'bottom',

            y: 15

        },

        legend: {

            layout: 'vertical',

            align: 'left',

            verticalAlign: 'top',

            x: 150,

            y: 100,

            floating: true,

            borderWidth: 1,

            backgroundColor: '#FFFFFF'

        },

        xAxis: {

            categories: ['Apples', 'Pears', 'Oranges', 'Bananas', 'Grapes', 'Plums', 'Strawberries', 'Raspberries']

        },

        yAxis: {

            title: {

                text: 'Y-Axis'

            },

            labels: {

                formatter: function() {

                    return this.value;

                }

            }

        },

        tooltip: {

            formatter: function() {

                return '<b>'+ this.series.name +'</b><br/>'+

                    this.x +': '+ this.y;

            }

        },

        plotOptions: {

            area: {

                fillOpacity: 0.5

            }

        },

        credits: {

            enabled: false

        },

        series: [{

            name: 'John',

            data: [0, 1, 4, 4, 5, 2, 3, 7]

        }, {

            name: 'Jane',

            data: [1, 0, 3, null, 3, 1, 2, 1]

        }]

    });



    /* Inverted axes */

    $('#inverted-axes').highcharts({

        chart: {

            type: 'area',

            inverted: true

        },

        title: {

            text: 'Average fruit consumption during one week'

        },

        subtitle: {

            style: {

                position: 'absolute',

                right: '0px',

                bottom: '10px'

            }

        },

        legend: {

            layout: 'vertical',

            align: 'right',

            verticalAlign: 'top',

            x: -150,

            y: 100,

            floating: true,

            borderWidth: 1,

            backgroundColor: '#FFFFFF'

        },

        xAxis: {

            categories: [

                'Monday',

                'Tuesday',

                'Wednesday',

                'Thursday',

                'Friday',

                'Saturday',

                'Sunday'

            ]

        },

        yAxis: {

            title: {

                text: 'Number of units'

            },

            labels: {

                formatter: function() {

                    return this.value;

                }

            },

            min: 0

        },

        plotOptions: {

            area: {

                fillOpacity: 0.5

            }

        },

        series: [{

            name: 'John',

            data: [3, 4, 3, 5, 4, 10, 12]

        }, {

            name: 'Jane',

            data: [1, 3, 4, 3, 3, 5, 4]

        }]

    });



    /*  Area-spline */

    $('#area-spline').highcharts({

        chart: {

            type: 'areaspline'

        },

        title: {

            text: 'Average fruit consumption during one week'

        },

        legend: {

            layout: 'vertical',

            align: 'left',

            verticalAlign: 'top',

            x: 150,

            y: 100,

            floating: true,

            borderWidth: 1,

            backgroundColor: '#FFFFFF'

        },

        xAxis: {

            categories: [

                'Monday',

                'Tuesday',

                'Wednesday',

                'Thursday',

                'Friday',

                'Saturday',

                'Sunday'

            ],

            plotBands: [{ // visualize the weekend

                from: 4.5,

                to: 6.5,

                color: 'rgba(68, 170, 213, .2)'

            }]

        },

        yAxis: {

            title: {

                text: 'Fruit units'

            }

        },

        tooltip: {

            shared: true,

            valueSuffix: ' units'

        },

        credits: {

            enabled: false

        },

        plotOptions: {

            areaspline: {

                fillOpacity: 0.5

            }

        },

        series: [{

            name: 'John',

            data: [3, 4, 3, 5, 4, 10, 12]

        }, {

            name: 'Jane',

            data: [1, 3, 4, 3, 3, 5, 4]

        }]

    });



    /* Area range */

    $.getJSON('http://www.highcharts.com/samples/data/jsonp.php?filename=range.json&callback=?', function(data) {



        $('#area-range').highcharts({



            chart: {

                type: 'arearange',

                zoomType: 'x'

            },



            title: {

                text: 'Temperature variation by day'

            },



            xAxis: {

                type: 'datetime'

            },



            yAxis: {

                title: {

                    text: null

                }

            },



            tooltip: {

                crosshairs: true,

                shared: true,

                valueSuffix: '°C'

            },



            legend: {

                enabled: false

            },



            series: [{

                name: 'Temperatures',

                data: data

            }]



        });

    });



    /* Area range and line */

    var ranges = [

            [1246406400000, 14.3, 27.7],

            [1246492800000, 14.5, 27.8],

            [1246579200000, 15.5, 29.6],

            [1246665600000, 16.7, 30.7],

            [1246752000000, 16.5, 25.0],

            [1246838400000, 17.8, 25.7],

            [1246924800000, 13.5, 24.8],

            [1247011200000, 10.5, 21.4],

            [1247097600000, 9.2, 23.8],

            [1247184000000, 11.6, 21.8],

            [1247270400000, 10.7, 23.7],

            [1247356800000, 11.0, 23.3],

            [1247443200000, 11.6, 23.7],

            [1247529600000, 11.8, 20.7],

            [1247616000000, 12.6, 22.4],

            [1247702400000, 13.6, 19.6],

            [1247788800000, 11.4, 22.6],

            [1247875200000, 13.2, 25.0],

            [1247961600000, 14.2, 21.6],

            [1248048000000, 13.1, 17.1],

            [1248134400000, 12.2, 15.5],

            [1248220800000, 12.0, 20.8],

            [1248307200000, 12.0, 17.1],

            [1248393600000, 12.7, 18.3],

            [1248480000000, 12.4, 19.4],

            [1248566400000, 12.6, 19.9],

            [1248652800000, 11.9, 20.2],

            [1248739200000, 11.0, 19.3],

            [1248825600000, 10.8, 17.8],

            [1248912000000, 11.8, 18.5],

            [1248998400000, 10.8, 16.1]

        ],

        averages = [

            [1246406400000, 21.5],

            [1246492800000, 22.1],

            [1246579200000, 23],

            [1246665600000, 23.8],

            [1246752000000, 21.4],

            [1246838400000, 21.3],

            [1246924800000, 18.3],

            [1247011200000, 15.4],

            [1247097600000, 16.4],

            [1247184000000, 17.7],

            [1247270400000, 17.5],

            [1247356800000, 17.6],

            [1247443200000, 17.7],

            [1247529600000, 16.8],

            [1247616000000, 17.7],

            [1247702400000, 16.3],

            [1247788800000, 17.8],

            [1247875200000, 18.1],

            [1247961600000, 17.2],

            [1248048000000, 14.4],

            [1248134400000, 13.7],

            [1248220800000, 15.7],

            [1248307200000, 14.6],

            [1248393600000, 15.3],

            [1248480000000, 15.3],

            [1248566400000, 15.8],

            [1248652800000, 15.2],

            [1248739200000, 14.8],

            [1248825600000, 14.4],

            [1248912000000, 15],

            [1248998400000, 13.6]

        ];





    $('#area-range-and-line').highcharts({



        title: {

            text: 'July temperatures'

        },



        xAxis: {

            type: 'datetime'

        },



        yAxis: {

            title: {

                text: null

            }

        },



        tooltip: {

            crosshairs: true,

            shared: true,

            valueSuffix: '°C'

        },



        legend: {

        },



        series: [{

            name: 'Temperature',

            data: averages,

            zIndex: 1,

            marker: {

                fillColor: 'white',

                lineWidth: 2,

                lineColor: Highcharts.getOptions().colors[0]

            }

        }, {

            name: 'Range',

            data: ranges,

            type: 'arearange',

            lineWidth: 0,

            linkedTo: ':previous',

            color: Highcharts.getOptions().colors[0],

            fillOpacity: 0.3,

            zIndex: 0

        }]



    });



});

