$(function () {



    /* Basic bar */

    $('#basic-bar').highcharts({

        chart: {

            type: 'bar'

        },

        title: {

            text: 'Historic World Population by Region'

        },

        subtitle: {

            text: 'Source: Wikipedia.org'

        },

        xAxis: {

            categories: ['Africa', 'America', 'Asia', 'Europe', 'Oceania'],

            title: {

                text: null

            }

        },

        yAxis: {

            min: 0,

            title: {

                text: 'Population (millions)',

                align: 'high'

            },

            labels: {

                overflow: 'justify'

            }

        },

        tooltip: {

            valueSuffix: ' millions'

        },

        plotOptions: {

            bar: {

                dataLabels: {

                    enabled: true

                }

            }

        },

        legend: {

            layout: 'vertical',

            align: 'right',

            verticalAlign: 'top',

            x: -40,

            y: 100,

            floating: true,

            borderWidth: 1,

            backgroundColor: '#FFFFFF',

            shadow: true

        },

        credits: {

            enabled: false

        },

        series: [{

            name: 'Year 1800',

            data: [107, 31, 635, 203, 2]

        }, {

            name: 'Year 1900',

            data: [133, 156, 947, 408, 6]

        }, {

            name: 'Year 2008',

            data: [973, 914, 4054, 732, 34]

        }]

    });



    /* Stacked bar */

    $('#stacked-bar').highcharts({

        chart: {

            type: 'bar'

        },

        title: {

            text: 'Stacked bar chart'

        },

        xAxis: {

            categories: ['Apples', 'Oranges', 'Pears', 'Grapes', 'Bananas']

        },

        yAxis: {

            min: 0,

            title: {

                text: 'Total fruit consumption'

            }

        },

        legend: {

            backgroundColor: '#FFFFFF',

            reversed: true

        },

        plotOptions: {

            series: {

                stacking: 'normal'

            }

        },

        series: [{

            name: 'John',

            data: [5, 3, 4, 7, 2]

        }, {

            name: 'Jane',

            data: [2, 2, 3, 2, 1]

        }, {

            name: 'Joe',

            data: [3, 4, 4, 2, 5]

        }]

    });



    /* Bar with negative stack */

    var chart,

        categories = ['0-4', '5-9', '10-14', '15-19',

            '20-24', '25-29', '30-34', '35-39', '40-44',

            '45-49', '50-54', '55-59', '60-64', '65-69',

            '70-74', '75-79', '80-84', '85-89', '90-94',

            '95-99', '100 +'];

    $(document).ready(function() {

        $('#bar-with-negative-stack').highcharts({

            chart: {

                type: 'bar'

            },

            title: {

                text: 'Population pyramid for Germany, midyear 2010'

            },

            subtitle: {

                text: 'Source: www.census.gov'

            },

            xAxis: [{

                categories: categories,

                reversed: false,

                labels: {

                    step: 1

                }

            }, { // mirror axis on right side

                opposite: true,

                reversed: false,

                categories: categories,

                linkedTo: 0,

                labels: {

                    step: 1

                }

            }],

            yAxis: {

                title: {

                    text: null

                },

                labels: {

                    formatter: function(){

                        return (Math.abs(this.value) / 1000000) + 'M';

                    }

                },

                min: -4000000,

                max: 4000000

            },



            plotOptions: {

                series: {

                    stacking: 'normal'

                }

            },



            tooltip: {

                formatter: function(){

                    return '<b>'+ this.series.name +', age '+ this.point.category +'</b><br/>'+

                        'Population: '+ Highcharts.numberFormat(Math.abs(this.point.y), 0);

                }

            },



            series: [{

                name: 'Male',

                data: [-1746181, -1884428, -2089758, -2222362, -2537431, -2507081, -2443179,

                    -2664537, -3556505, -3680231, -3143062, -2721122, -2229181, -2227768,

                    -2176300, -1329968, -836804, -354784, -90569, -28367, -3878]

            }, {

                name: 'Female',

                data: [1656154, 1787564, 1981671, 2108575, 2403438, 2366003, 2301402, 2519874,

                    3360596, 3493473, 3050775, 2759560, 2304444, 2426504, 2568938, 1785638,

                    1447162, 1005011, 330870, 130632, 21208]

            }]

        });

    });



    /* Basic column */

    $('#basic-column').highcharts({

        chart: {

            type: 'column'

        },

        title: {

            text: 'Monthly Average Rainfall'

        },

        subtitle: {

            text: 'Source: WorldClimate.com'

        },

        xAxis: {

            categories: [

                'Jan',

                'Feb',

                'Mar',

                'Apr',

                'May',

                'Jun',

                'Jul',

                'Aug',

                'Sep',

                'Oct',

                'Nov',

                'Dec'

            ]

        },

        yAxis: {

            min: 0,

            title: {

                text: 'Rainfall (mm)'

            }

        },

        tooltip: {

            headerFormat: '<span style="font-size:10px">{point.key}</span><table>',

            pointFormat: '<tr><td style="color:{series.color};padding:0">{series.name}: </td>' +

                '<td style="padding:0"><b>{point.y:.1f} mm</b></td></tr>',

            footerFormat: '</table>',

            shared: true,

            useHTML: true

        },

        plotOptions: {

            column: {

                pointPadding: 0.2,

                borderWidth: 0

            }

        },

        series: [{

            name: 'Tokyo',

            data: [49.9, 71.5, 106.4, 129.2, 144.0, 176.0, 135.6, 148.5, 216.4, 194.1, 95.6, 54.4]



        }, {

            name: 'New York',

            data: [83.6, 78.8, 98.5, 93.4, 106.0, 84.5, 105.0, 104.3, 91.2, 83.5, 106.6, 92.3]



        }, {

            name: 'London',

            data: [48.9, 38.8, 39.3, 41.4, 47.0, 48.3, 59.0, 59.6, 52.4, 65.2, 59.3, 51.2]



        }, {

            name: 'Berlin',

            data: [42.4, 33.2, 34.5, 39.7, 52.6, 75.5, 57.4, 60.4, 47.6, 39.1, 46.8, 51.1]



        }]

    });



    /* Column with negative values */

    $('#column-with-negative-values').highcharts({

        chart: {

            type: 'column'

        },

        title: {

            text: 'Column chart with negative values'

        },

        xAxis: {

            categories: ['Apples', 'Oranges', 'Pears', 'Grapes', 'Bananas']

        },

        credits: {

            enabled: false

        },

        series: [{

            name: 'John',

            data: [5, 3, 4, 7, 2]

        }, {

            name: 'Jane',

            data: [2, -2, -3, 2, 1]

        }, {

            name: 'Joe',

            data: [3, 4, 4, -2, 5]

        }]

    });



    /*  Stacked column */

    $('#stacked-column').highcharts({

        chart: {

            type: 'column'

        },

        title: {

            text: 'Stacked column chart'

        },

        xAxis: {

            categories: ['Apples', 'Oranges', 'Pears', 'Grapes', 'Bananas']

        },

        yAxis: {

            min: 0,

            title: {

                text: 'Total fruit consumption'

            },

            stackLabels: {

                enabled: true,

                style: {

                    fontWeight: 'bold',

                    color: (Highcharts.theme && Highcharts.theme.textColor) || 'gray'

                }

            }

        },

        legend: {

            align: 'right',

            x: -70,

            verticalAlign: 'top',

            y: 20,

            floating: true,

            backgroundColor: (Highcharts.theme && Highcharts.theme.legendBackgroundColorSolid) || 'white',

            borderColor: '#CCC',

            borderWidth: 1,

            shadow: false

        },

        tooltip: {

            formatter: function() {

                return '<b>'+ this.x +'</b><br/>'+

                    this.series.name +': '+ this.y +'<br/>'+

                    'Total: '+ this.point.stackTotal;

            }

        },

        plotOptions: {

            column: {

                stacking: 'normal',

                dataLabels: {

                    enabled: true,

                    color: (Highcharts.theme && Highcharts.theme.dataLabelsColor) || 'white'

                }

            }

        },

        series: [{

            name: 'John',

            data: [5, 3, 4, 7, 2]

        }, {

            name: 'Jane',

            data: [2, 2, 3, 2, 1]

        }, {

            name: 'Joe',

            data: [3, 4, 4, 2, 5]

        }]

    });



    /* Stacked and grouped column */

    $('#stacked-and-grouped-column').highcharts({



        chart: {

            type: 'column'

        },



        title: {

            text: 'Total fruit consumtion, grouped by gender'

        },



        xAxis: {

            categories: ['Apples', 'Oranges', 'Pears', 'Grapes', 'Bananas']

        },



        yAxis: {

            allowDecimals: false,

            min: 0,

            title: {

                text: 'Number of fruits'

            }

        },



        tooltip: {

            formatter: function() {

                return '<b>'+ this.x +'</b><br/>'+

                    this.series.name +': '+ this.y +'<br/>'+

                    'Total: '+ this.point.stackTotal;

            }

        },



        plotOptions: {

            column: {

                stacking: 'normal'

            }

        },



        series: [{

            name: 'John',

            data: [5, 3, 4, 7, 2],

            stack: 'male'

        }, {

            name: 'Joe',

            data: [3, 4, 4, 2, 5],

            stack: 'male'

        }, {

            name: 'Jane',

            data: [2, 5, 6, 2, 1],

            stack: 'female'

        }, {

            name: 'Janet',

            data: [3, 0, 4, 4, 3],

            stack: 'female'

        }]

    });



    /* Stacked percentage column */

    $('#stacked-percentage-column').highcharts({

        chart: {

            type: 'column'

        },

        title: {

            text: 'Stacked column chart'

        },

        xAxis: {

            categories: ['Apples', 'Oranges', 'Pears', 'Grapes', 'Bananas']

        },

        yAxis: {

            min: 0,

            title: {

                text: 'Total fruit consumption'

            }

        },

        tooltip: {

            pointFormat: '<span style="color:{series.color}">{series.name}</span>: <b>{point.y}</b> ({point.percentage:.0f}%)<br/>',

            shared: true

        },

        plotOptions: {

            column: {

                stacking: 'percent'

            }

        },

        series: [{

            name: 'John',

            data: [5, 3, 4, 7, 2]

        }, {

            name: 'Jane',

            data: [2, 2, 3, 2, 1]

        }, {

            name: 'Joe',

            data: [3, 4, 4, 2, 5]

        }]

    });



    /* Column with rotated labels */

    $('#column-with-rotated-labels').highcharts({

        chart: {

            type: 'column',

            margin: [ 50, 50, 100, 80]

        },

        title: {

            text: 'World\'s largest cities per 2008'

        },

        xAxis: {

            categories: [

                'Tokyo',

                'Jakarta',

                'New York',

                'Seoul',

                'Manila',

                'Mumbai',

                'Sao Paulo',

                'Mexico City',

                'Dehli',

                'Osaka',

                'Cairo',

                'Kolkata',

                'Los Angeles',

                'Shanghai',

                'Moscow',

                'Beijing',

                'Buenos Aires',

                'Guangzhou',

                'Shenzhen',

                'Istanbul'

            ],

            labels: {

                rotation: -45,

                align: 'right',

                style: {

                    fontSize: '13px',

                    fontFamily: 'Verdana, sans-serif'

                }

            }

        },

        yAxis: {

            min: 0,

            title: {

                text: 'Population (millions)'

            }

        },

        legend: {

            enabled: false

        },

        tooltip: {

            pointFormat: 'Population in 2008: <b>{point.y:.1f} millions</b>'

        },

        series: [{

            name: 'Population',

            data: [34.4, 21.8, 20.1, 20, 19.6, 19.5, 19.1, 18.4, 18,

                17.3, 16.8, 15, 14.7, 14.5, 13.3, 12.8, 12.4, 11.8,

                11.7, 11.2],

            dataLabels: {

                enabled: true,

                rotation: -90,

                color: '#FFFFFF',

                align: 'right',

                x: 4,

                y: 10,

                style: {

                    fontSize: '13px',

                    fontFamily: 'Verdana, sans-serif',

                    textShadow: '0 0 3px black'

                }

            }

        }]

    });



    /* Data defined in a HTML table */

    $('#data-defined-in-a-HTML-table').highcharts({

        data: {

            table: document.getElementById('datatable')

        },

        chart: {

            type: 'column'

        },

        title: {

            text: 'Data extracted from a HTML table in the page'

        },

        yAxis: {

            allowDecimals: false,

            title: {

                text: 'Units'

            }

        },

        tooltip: {

            formatter: function() {

                return '<b>'+ this.series.name +'</b><br/>'+

                    this.y +' '+ this.x.toLowerCase();

            }

        }

    });



    /* Column range */

    $('#column-range').highcharts({



        chart: {

            type: 'columnrange',

            inverted: true

        },



        title: {

            text: 'Temperature variation by month'

        },



        subtitle: {

            text: 'Observed in Vik i Sogn, Norway, 2009'

        },



        xAxis: {

            categories: ['Jan', 'Feb', 'Mar', 'Apr', 'May', 'Jun', 'Jul', 'Aug', 'Sep', 'Oct', 'Nov', 'Dec']

        },



        yAxis: {

            title: {

                text: 'Temperature ( °C )'

            }

        },



        tooltip: {

            valueSuffix: '°C'

        },



        plotOptions: {

            columnrange: {

                dataLabels: {

                    enabled: true,

                    formatter: function () {

                        return this.y + '°C';

                    }

                }

            }

        },



        legend: {

            enabled: false

        },



        series: [{

            name: 'Temperatures',

            data: [

                [-9.7, 9.4],

                [-8.7, 6.5],

                [-3.5, 9.4],

                [-1.4, 19.9],

                [0.0, 22.6],

                [2.9, 29.5],

                [9.2, 30.7],

                [7.3, 26.5],

                [4.4, 18.0],

                [-3.1, 11.4],

                [-5.2, 10.4],

                [-13.5, 9.8]

            ]

        }]



    });



});

