<?php
session_start();
$_SESSION['wtype'] = 'B';

if(!$_SESSION['isadmin'])
{
	header("Location: login.php?ref=edit.php?pageid=1");
	exit;
}

if($_SESSION['country_login'] == 1 || $_SESSION['country_login'] == 2) {
	header("Location: index.php");
	exit;
}

include_once("../functions.php");
$conn = dbconnect();


//Check if club country login and has access to this club
if($_SESSION['country_login'] == 1 && $_GET['cid']) {
	$has_access = mysqli_num_rows(mysqli_query($conn,"SELECT country FROM club_registrations WHERE id=".mysqli_real_escape_string($conn,$_GET['cid'])." AND country IN (".$_SESSION['country_access_array'].")"));
	
	if($has_access!==1) {
		header("Location: index.php");
		exit;
	}
}

include "headers/common_header.php";

if($_SESSION['country_login'] == 1) {
	$get_all_clubs = mysqli_query($conn,"SELECT * FROM club_registrations WHERE country IN (".$_SESSION['country_access_array'].") AND hideit=0 ORDER BY golfclub ASC");
} else {
	$get_all_clubs = mysqli_query($conn,"SELECT * FROM club_registrations WHERE hideit=0 ORDER BY golfclub ASC");
}

//get players details
if($_POST['fromdate'] && $_POST['todate'] ) {
    
$get_details = mysqli_query($conn,"SELECT makelive.mobile,makelive.clubid,makelive.makeliveon,makelive.processed,makelive_info.player_name,makelive_info.club_name,makelive_info.created_on FROM 
makelive LEFT JOIN makelive_info ON makelive.id = makelive_info.makelive_id WHERE date(makelive.makeliveon) >='".$_POST['fromdate']."' AND date(makelive.makeliveon) <='".mysqli_real_escape_string($conn,$_POST['todate'])."' ORDER BY clubid ASC,makeliveon DESC");
    
}else{

$get_details = mysqli_query($conn,"SELECT makelive.mobile,makelive.clubid,makelive.makeliveon,makelive.processed,makelive_info.player_name,makelive_info.club_name,makelive_info.created_on FROM 
makelive LEFT JOIN makelive_info ON makelive.id = makelive_info.makelive_id  ORDER BY clubid ASC,makeliveon DESC");

}
?>

<!--BEGIN PAGE WRAPPER-->

        <div id="page-wrapper"><!--BEGIN TITLE & BREADCRUMB PAGE-->

            <div id="title-breadcrumb-option-demo" class="page-title-breadcrumb">

                <div class="page-header pull-left">

                    <div class="page-title">Makelive Report</div>

                </div>

                <ol class="breadcrumb page-breadcrumb pull-right">

                    <li><i class="fa fa-home"></i>&nbsp;<a href="index.php">Home</a>&nbsp;&nbsp;<i class="fa fa-angle-right"></i>&nbsp;&nbsp;</li>

                    <li class="active">Makelive Report</li>

                </ol>

                <div class="clearfix"></div>

            </div>
            <!--END TITLE & BREADCRUMB PAGE-->

<!--BEGIN CONTENT TABLE-->

            <div class="page-content">
              <!--<button id="exporttoexcel" style="float:right;border:1px solid black;margin:4px;">Download</button>-->
                <div class="row">

                    <div class="col-lg-12">

                        <div class="panel panel-green">

                            <div class="panel-heading">Makelive Report:</div>

                           <div class="panel-body">

                                <div id="no-more-tables">

                                   <!--Search feature--> 
                                    <div class="form-group">
                                        
                                       <form class="form-inline" method="post" action="#">
                                        
                                        <label>FROM DATE </label>
                                        <input type="date" name="fromdate" class="form-control" placeholder="From date">

                                        <label>TO DATE </label>
                                        <input type="date" name="todate" class="form-control" placeholder="To date">

                                        <button type="submit" name="search" class="btn btn-primary">Search</button>
                                    </form>
                                    <!--Search feature -->

                                    </div>
                                    
                                    <table class="table table-bordered table-striped table-condensed cf tablesorter" id="players" data-sortlist="[[0,1]]">

                                        <thead class="cf">

                                        <tr>

                                            <th>Sr. No.</th>

                                             <th class="numeric">Mobile</th>
                                             <th class="numeric">Player Name</th>
                                             <th class="numeric">Club Name</th>
                                             <th>Course Name</th>
											 <th>Makelive On</th>
                                             <th>submitted On</th>
                                             <th>live</th>

                                        </tr>

                                        </thead>

										<?php 
                                         $srno = 1;
                                        while($player = mysqli_fetch_array($get_details)){
									
										?>

                                        <tbody>

                                        <tr>

                                            <td data-title="Sr. No."><?php echo $srno; ?></td>

                                            <td data-title="Mobile" class="numeric">
                                            <?php echo $player['mobile'] ?>
                                            </td>

                                            <td data-title="Player Name" class="numeric">
                                            <?php echo ucwords(strtolower($player['player_name']))?>
                                            </td>

                                            <td data-title="club Name" class="numeric">
                                            <?php 
                                            $clubname = mysqli_fetch_array(mysqli_query($conn,"SELECT golfclub FROM club_registrations WHERE id='".$player['clubid']."'"));
                                            echo $clubname['golfclub']; 
                                            ?>
                                            </td>

                                            <td data-title="Course Name" class="numeric">
                                            <?php echo $player['club_name'] ?>
                                            </td>

                                            <td data-title="Makelive On" class="numeric">
                                            <?php echo $player['makeliveon'] ?>
                                            </td>

                                            <td data-title="Created On" class="numeric">
                                            <?php echo $player['created_on'] ?>
                                            </td>

                                            <td data-title="Processed" class="numeric">
                                            <?php if($player['processed'] == '0'){ echo "No"; }else{echo "Yes"; } ?>
                                            </td>

											</td>
										
                                        </tr>

                                        </tbody>

										<?php $srno++;}?>
										
                                    </table>
                                   
                                </div>

                            </div>

                        </div>

                    </div>

                </div>

            </div>
            <!--END CONTENT-->
<?php include "footer.php";?>