<?php
session_start();

if(!$_SESSION['isadmin']) {
	header("Location: login.php?ref=edit.php?pageid=1");
	exit;
}

if($_SESSION['country_login'] == 1) {
	header("Location: index.php");
	exit;
}

include_once("../functions.php");

$conn = dbconnect();

include "headers/common_header.php";

$get_all_entries = mysqli_query($conn,"SELECT * FROM join_a_league as j, golfsurprizes as g WHERE j.mobile=g.mob ORDER BY j.id DESC");
?>

<!--BEGIN PAGE WRAPPER-->

        <div id="page-wrapper"><!--BEGIN TITLE & BREADCRUMB PAGE-->

            <div id="title-breadcrumb-option-demo" class="page-title-breadcrumb">

                <div class="page-header pull-left">

                    <div class="page-title">All Players</div>

                </div>

                <ol class="breadcrumb page-breadcrumb pull-right">

                    <li><i class="fa fa-home"></i>&nbsp;<a href="index.php">Home</a>&nbsp;&nbsp;<i class="fa fa-angle-right"></i>&nbsp;&nbsp;</li>

                    <li class="active">All players</li>

                </ol>

                <div class="clearfix"></div>

            </div>

            <!--END TITLE & BREADCRUMB PAGE-->

            <!--BEGIN CONTENT TABLE-->

            <div class="page-content">

            <button id="exporttoexcel" style="float:right;border:1px solid black;margin:4px;">Download</button>

                <div class="row">

                    <div class="col-lg-12">

                        <div class="panel panel-green">

                            <div class="panel-heading">All Players</div>

                           <div class="panel-body">

                                <div id="no-more-tables">

                                    <table class="table table-bordered table-striped table-condensed cf" id="players">

                                        <thead class="cf">

                                        <tr>

                                            <th>Sr. No.</th>

                                            <th class="numeric">Name</th>

                                            <th>Email</th>

                                            <th class="numeric">Mobile</th>

                                            <th>Joined on</th>
                                            
                                            <th>Has handicap</th>
                                            
                                            <th>Golf course member</th>
                                            
                                            <th>Hear about us</th>
                                            
                                            <th>Course name</th>
                                            
                                            <th>Plays in tournaments/comps</th>
                                            
                                            <th>Credits</th>
                                            
                                            <th>Add Credits</th>

                                        </tr>

                                        </thead>

										<?php 

                                        $srno = 1;

                                        while($entry = mysqli_fetch_array($get_all_entries)){?>

                                        <tbody>

                                        <tr>

                                            <td data-title="Sr. No."><?php echo $srno; ?></td>

                                            <td data-title="Name" class="numeric"><?php echo $entry['fname']." ".$entry['lname']?></td>

                                            <td data-title="Email"><?php echo $entry['email']?></td>

                                            <td data-title="Mobile" class="numeric"><?php echo $entry['mobile']?></td>

                                            <td data-title="No Entries" class="numeric"><?php echo $entry['joinedon']?></td>
                                            
                                            <td data-title="Mobile" class="numeric"><?php echo $entry['has_handicap']?></td>
                                            
                                            <td data-title="Mobile" class="numeric"><?php echo $entry['is_golfcourse_member']?></td>
                                            
                                            <td data-title="Mobile" class="numeric"><?php echo $entry['media_type']?></td>

                                            
                                            <td data-title="Mobile" class="numeric"><?php echo $entry['course_name']?></td>

                                            <td data-title="Mobile" class="numeric"><?php echo $entry['t_or_c']?></td>
                                            
                                            <td data-title="Mobile" class="numeric"><?php echo $entry['gs_balance']?></td>
                                            
                                            <td data-title="Add Balance">
                                            <select name="add_balance" onChange="gsbalance($(this).val(),<?php echo $entry['mobile']?>)">
                                            <option value=''>--Select--</option>
                                            <?php for($i=1;$i<=10;$i++) { ?>
                                            <option value=<?php echo $i;?>><?php echo $i ?></option>
                                            <?php } ?>
                                            </select>
                                            <div id="<?php echo $entry['mobile']?>"></div>
                                            </td>
                                        </tr>

                                        </tbody>

										<?php $srno++;}?>

                                    </table>

                                </div>

                            </div>

                        </div>

                    </div>

                </div>

            </div>

            <!--END CONTENT-->
<script>
    function gsbalance(gsbalance,mobile) {
                $.ajax({
                    type: "GET",
                    url: 'update_add_gsbalance_ajax.php',
                    data: { gsbalance:gsbalance,mobile:mobile},
                    beforeSend: function(){
                        $('#'+mobile).html("Saving");
                    },
                    success: function(data) {
                        $('#'+mobile).html(data);
                        window.location.reload();
                    },
                    error: function() {
                        $('#'+mobile).html('Something went wrong');
                    },
                    complete: function() {
                        //$('#'+barcode).html(data);
                    }
                });
        };
    </script>
    
            <script src= "//cdn.rawgit.com/rainabba/jquery-table2excel/1.1.0/dist/jquery.table2excel.min.js"></script> 
            <script>
                $(document).ready(function() {
                    $("#exporttoexcel").click(function(){
                        $("#players").table2excel({
                            filename: "Players",
                        });
                    });
                });	
            </script>		

<?php include "footer.php";?>